%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%


%    Main MoM matrix, for arbitrary charged body


function A = matrixA (EPS,dS,x,y,z)
N = length(x);
if (length(dS)== N)
    for i = 1 : N
        for j = 1 : N
            if nargin == 3  
                r = sqrt ((x(j)-x(i))^2); 
            end;
            if nargin == 4 
                r = sqrt ((x(j)-x(i))^2 + (y(j)-y(i))^2); 
            end;
            if nargin == 5 
                r = sqrt ((x(j)-x(i))^2 + (y(j)-y(i))^2 + (z(j)-z(i))^2); 
            end;
            if (i==j)
                A(i,j) = sqrt(dS(j))/(2*sqrt(pi)*EPS);
            else
                A(i,j) = dS(j)/(4*pi*EPS*r);
            end;
        end;
    end;
else
    A = 0;
    disp ('Incorrect input data in function matrixA');
end;
